package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.sessions;

import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement : Authentification
 *
 */
public class Authentifier {

	/**
	 * Le loggeur
	 */
	private static Logger log = Logger.getLogger(Authentifier.class);
	
	/**
	 * Renvoie le rsultat de l'opration
	 * @param librairie Librairie PKCS#11  utiliser
	 * @param idSession Identifiant de la session
	 * @param pin PIN  utiliser
	 * @param isSO Boolen permettant de dterminer s'il s'agit d'une authentification Security Officer (SO)
	 * @return Rsultat de l'opration
	 * @throws ExceptionTraitement 
	 */
	public static Resultat traitementP11(PKCS11 librairie, long idSession, char[] pin, boolean isSO) throws ExceptionTraitement {


		try {
			
			if(librairie != null) {		
		
				Resultat resultat = new Resultat("Authentification d'un "+(isSO?"Security Officer":"utilisateur")+" (C_Login)");
				
				try {
					
					if(pin != null)
						// Traitement  tester
						librairie.C_Login(idSession, isSO?PKCS11Constants.CKU_SO:PKCS11Constants.CKU_USER, pin);
					else {
						
						// Si le PIN est nul on lve l'exception
						log.error("Le code PIN est nul");
						throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SESSIONS_AUTHENTIFIE, "Le code PIN est nul");
						
					}
		
					
				} catch (PKCS11Exception e) {

					log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
					resultat.setCodeRetour(e.getErrorCode());
					
				}
				
				return resultat;
				
			} else {
				
				// Si la librairie est nulle il est impossible de raliser l'opration
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SESSIONS_AUTHENTIFIE, "La librairie est nulle");
				
			}

		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SESSIONS_AUTHENTIFIE, "Une erreur inattendue est survenue");
			
		}
		
	}

}
